# C++ Code Language

Welcome to this GitHub repository that covers the basics of the C++ programming language. Why the C++ language? Windows, at its core, is primarily written in C. Despite that the foundational layers of Windows, like the kernel, are primarily written in C. Many of the higher-level components and applications like Graphical User Interfaces are written in C++ for example.

# What is C++ ?

C++ is a general-purpose programming language created by Bjarne Stroustrup. The language has expanded over the years, and modern C++ now has object-oriented, procedural, and generic programming features, while also providing facilities for low-level memory manipulation.

C++ is a versatile programming language engineered primarily for systems programming. It introduces capabilities for:

- Data abstraction, typically achieved through custom user-defined classes,
- Object-oriented programming, facilitated by features like inheritance, and
- Generic programming, exemplified by the use of reusable data containers and algorithms.

# Difference between C and C++

| Feature      | C                                        | C++                                        |
|----------------------|------------------------------------------|--------------------------------------------|
| **Paradigm**         | Procedural                               | Multi-paradigm (Procedural, Object-Oriented, and more) |
| **Foundational Features** | Functions, structs, pointers, etc.    | Inherits all of C's features and adds classes, templates, exceptions, etc. |
| **Object-Oriented**  | No native support                        | Supports classes, inheritance, polymorphism, encapsulation |
| **Standard Library** | Limited (e.g., `stdio.h`, `stdlib.h`)    | Extensive (includes STL with containers like `vector`, `map`, and more) |
| **Memory Management**| Manual with malloc/free                  | Supports both manual and constructors/destructors for automatic resource management |
| **Exception Handling**| Typically uses error codes/returns      | Provides try, catch, throw for exceptions |
| **Templates**        | Not supported                            | Supports function and class templates     |
| **Overloading**      | Doesn't support function or operator overloading | Supports both function and operator overloading |
| **Namespaces**       | Not available                            | Supports namespaces to avoid name conflicts |
| **File Extensions**  | Commonly `.c` and `.h`                   | Commonly `.cpp`, `.cxx`, `.hpp`, `.hxx`   |



# What will we cover?

```
- Section 1: Classes
- Section 2: Initializer Lists
- Section 3: Overloading Function Templates
- Section 4: Copy and Move Constructors
- Section 5: Inheritance
- Section 6: Smart Pointers
- Section 7: Standard Libraries
```

# How to Use This Repository?

1. **Navigate:** Go through each topic one by one or jump to the sections you're interested in. However, it is recommended to go through all the sections.
2. **Practice:** Alongside the theory, you'll find practical examples with code snippets. Make sure to compile these code snippets within Visual Studio. This allows you to understand the topic better.

# Contributions

If you find any mistakes or areas of improvement, please feel free to create an issue or submit a pull request.
